/*
 * Decompiled with CFR 0.152.
 */
package com.yumawk.mplugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yumawk.mplugin.aip.mTokenPlugin;
import com.yumawk.util.Jdk7Base64;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class TokenPlugin {
    private mTokenPlugin mTokenPlugin = new mTokenPlugin();
    private String LastError = null;
    private int LastErrorCode = 0;

    public boolean SOF_LoadLibrary() {
        ObjectMapper mapper = null;
        JsonNode node = null;
        String json = this.mTokenPlugin.SOF_LoadLibrary();
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return false;
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.LastErrorCode != 0) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
        }
        return this.LastErrorCode == 0;
    }

    public String SOF_EnumDevice() {
        String deviceList = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        String json = this.mTokenPlugin.SOF_EnumDevice();
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return "";
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            if (this.LastErrorCode != 0) {
                deviceList = "";
                this.LastError = "\u672a\u627e\u5230UKey\uff01";
            } else {
                deviceList = node.get("array").asText();
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return deviceList;
    }

    public boolean SOF_GetDeviceInstance(String deviceName) {
        ObjectMapper mapper = null;
        JsonNode node = null;
        String json = this.mTokenPlugin.SOF_GetDeviceInstance(deviceName, "");
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return false;
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.LastErrorCode == 0;
    }

    public String SOF_EnumCertContiner(String deviceName) {
        ObjectMapper mapper = null;
        JsonNode node = null;
        String containerNameList = null;
        String json = this.mTokenPlugin.SOF_EnumCertContiner(deviceName);
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return "";
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            if (this.LastErrorCode != 0) {
                this.LastError = "\u83b7\u53d6\u5bb9\u5668\u5217\u8868\u5931\u8d25\uff01";
            } else {
                containerNameList = node.get("containerName").asText();
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return containerNameList;
    }

    public String SOF_GetUserList(String deviceName) {
        String array = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        String json = this.mTokenPlugin.SOF_GetUserList(deviceName);
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return "";
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            array = node.get("array").asText();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return array;
    }

    public boolean SOF_Login(String deviceName, String passWd) {
        ObjectMapper mapper = null;
        JsonNode node = null;
        if (null == passWd || passWd.length() < 6) {
            this.LastErrorCode = -1;
            this.LastError = "Ukey\u5bc6\u7801\u5fc5\u987b\u4e3a4-6\u4f4d!";
            return false;
        }
        String json = this.mTokenPlugin.SOF_Login(deviceName, passWd);
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return false;
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.LastErrorCode != 0) {
            int retryCount = this.SOF_GetPinRetryCount(deviceName);
            this.LastError = retryCount >= 0 ? "Ukey\u767b\u5f55\u5931\u8d25\uff01\u5269\u4f59\u5c1d\u8bd5\u6b21\u6570\uff1a" + retryCount : "Ukey\u767b\u5f55\u5931\u8d25\uff01\u9519\u8bef\u4ee3\u7801\uff1a" + retryCount;
            return false;
        }
        return true;
    }

    public int SOF_GetPinRetryCount(String deviceName) {
        ObjectMapper mapper = null;
        JsonNode node = null;
        int retryCount = 0;
        int m_code = 0;
        String json = this.mTokenPlugin.SOF_GetPinRetryCount(deviceName);
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return -2;
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            m_code = node.get("errorCode").asInt();
            retryCount = m_code == 0 ? node.get("retryCount").asInt() : -2;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return retryCount;
    }

    public String SOF_ExportUserCert(String deviceName, String containerName, int keySpec) {
        String cert = null;
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        if (keySpec != 1 && keySpec != 0) {
            this.LastErrorCode = -1;
            this.LastError = "\u5bc6\u94a5\u7c7b\u578b\u9519\u8bef!\u8bf7\u4f20\u51651(\u7b7e\u540d)\u62160(\u52a0\u5bc6)";
            return null;
        }
        if (containerName == null || containerName.isEmpty()) {
            this.LastErrorCode = -1;
            this.LastError = "\u5bb9\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
            return null;
        }
        json = this.mTokenPlugin.SOF_ExportUserCert(deviceName, containerName, keySpec);
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return "";
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            if (this.LastErrorCode != 0) {
                cert = "";
                this.LastError = "\u8bc1\u4e66\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u52a0\u68c0\u6d4bKey\u4e2d\u662f\u5426\u5b58\u5728\u8bc1\u4e66\uff01";
            } else {
                cert = node.get("cert").asText();
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cert;
    }

    public boolean SOF_SetDigestMethod() {
        return this.SOF_SetDigestMethod(1);
    }

    public boolean SOF_SetDigestMethod(int digestMethod) {
        Object cert = null;
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        if (digestMethod != 1) {
            if (digestMethod != 4) {
                this.LastErrorCode = -1;
                this.LastError = "\u6458\u8981\u7b97\u6cd5\u9519\u8bef!\u8bf7\u4f20\u5165SGD_SM3\u6216SGD_SHA256";
                return false;
            }
        }
        if ((json = this.mTokenPlugin.SOF_SetDigestMethod(digestMethod)) == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return false;
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.LastErrorCode == 0;
    }

    public boolean SOF_SetUserID() {
        Object cert = null;
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        json = this.mTokenPlugin.SOF_SetUserID();
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return false;
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.LastErrorCode == 0;
    }

    public String SOF_SignData(String deviceName, String containerName, int keySpec, String inData) {
        String signData = null;
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        if (inData == null || inData.length() == 0) {
            this.LastErrorCode = -1;
            this.LastError = "\u5f85\u7b7e\u540d\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!";
            return null;
        }
        String b64_b64_data = Jdk7Base64.encode(inData.getBytes(StandardCharsets.UTF_8));
        json = this.mTokenPlugin.SOF_SignData(deviceName, containerName, keySpec, b64_b64_data, inData.length());
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return "";
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            signData = node.get("signed").asText();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return signData;
    }

    public String GetDeviceNumber(String base64Cert) {
        return this.GetDeviceNumber(base64Cert, true);
    }

    public String GetDeviceNumber(String base64Cert, boolean isDecimal) {
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        String certSerial = null;
        json = this.mTokenPlugin.SOF_GetCertInfo(base64Cert, 2);
        if (json == null || json.isEmpty()) {
            this.LastError = "\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25,\u8bf7\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u6700\u65b0\u9a71\u52a8!";
            this.LastErrorCode = -1;
            return "";
        }
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            certSerial = node.get("info").asText();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (isDecimal) {
            certSerial = new BigInteger(certSerial, 16).toString(10);
        }
        return certSerial;
    }

    public String GetCertSubject(String base64Cert) {
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        String subject = null;
        json = this.mTokenPlugin.SOF_GetCertInfo(base64Cert, 7);
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            subject = node.get("info").asText();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return subject;
    }

    public String GetUserName(String base64Cert) {
        String json = null;
        ObjectMapper mapper = null;
        JsonNode node = null;
        String subject = null;
        json = this.mTokenPlugin.SOF_GetCertInfo(base64Cert, 49);
        mapper = new ObjectMapper();
        try {
            node = mapper.readTree(json);
            this.LastErrorCode = node.get("errorCode").asInt();
            subject = node.get("info").asText();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return subject;
    }

    public String GetLastError() {
        return this.LastError;
    }

    public String SetLastError(String err) {
        this.LastError = err;
        return this.LastError;
    }

    public int GetLastErrorCode() {
        return this.LastErrorCode;
    }
}

