/*
 * Decompiled with CFR 0.152.
 */
package com.yumawk.util;

public class Jdk7Base64 {
    private static final char[] ENCODE_TABLE;
    private static final int[] DECODE_TABLE;

    private Jdk7Base64() {
    }

    public static String encode(byte[] src) {
        if (src == null) {
            return null;
        }
        int len = src.length;
        StringBuilder sb = new StringBuilder((len + 2) / 3 * 4);
        int i = 0;
        for (int remain = len; remain > 0; remain -= 3) {
            int b0 = src[i++] & 0xFF;
            int b1 = remain > 1 ? src[i++] & 0xFF : 0;
            int b2 = remain > 2 ? src[i++] & 0xFF : 0;
            int bits = b0 << 16 | b1 << 8 | b2;
            sb.append(ENCODE_TABLE[bits >>> 18 & 0x3F]);
            sb.append(ENCODE_TABLE[bits >>> 12 & 0x3F]);
            sb.append(remain > 1 ? ENCODE_TABLE[bits >>> 6 & 0x3F] : (char)'=');
            sb.append(remain > 2 ? ENCODE_TABLE[bits & 0x3F] : (char)'=');
        }
        return sb.toString();
    }

    public static byte[] decode(String base64) {
        if (base64 == null) {
            return null;
        }
        char[] src = base64.toCharArray();
        int len = src.length;
        int pad = 0;
        for (int i = len - 1; i >= 0 && src[i] == '='; --i) {
            ++pad;
        }
        int rawLen = len * 6 / 8 - pad;
        byte[] out = new byte[rawLen];
        int i = 0;
        int op = 0;
        while (i < len) {
            int a = DECODE_TABLE[src[i++]];
            int b = DECODE_TABLE[src[i++]];
            int c = DECODE_TABLE[src[i++]];
            int d = DECODE_TABLE[src[i++]];
            int bits = a << 18 | b << 12 | (c & 0x3F) << 6 | d & 0x3F;
            if (op < rawLen) {
                out[op++] = (byte)(bits >> 16);
            }
            if (op < rawLen) {
                out[op++] = (byte)(bits >> 8);
            }
            if (op >= rawLen) continue;
            out[op++] = (byte)bits;
        }
        return out;
    }

    static {
        int i;
        ENCODE_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        DECODE_TABLE = new int[128];
        for (i = 0; i < 128; ++i) {
            Jdk7Base64.DECODE_TABLE[i] = -1;
        }
        for (i = 0; i < ENCODE_TABLE.length; ++i) {
            Jdk7Base64.DECODE_TABLE[Jdk7Base64.ENCODE_TABLE[i]] = i;
        }
        Jdk7Base64.DECODE_TABLE[61] = 0;
    }
}

